/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.messages;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.client.HudOverlayHandler;
import de.srendi.advancedperipherals.common.argoggles.ARRenderAction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateHudCanvasMessage {
    private static final String LIST = "list";
    private List<ARRenderAction> canvas;

    public UpdateHudCanvasMessage(List<ARRenderAction> canvas) {
        this.canvas = canvas;
    }

    public static UpdateHudCanvasMessage decode(FriendlyByteBuf buf) {
        ByteBufInputStream streamin = new ByteBufInputStream((ByteBuf)buf);
        ArrayList<ARRenderAction> canvas = new ArrayList<ARRenderAction>();
        try {
            CompoundTag nbt = NbtIo.m_128934_((DataInput)streamin, (NbtAccounter)NbtAccounter.f_128917_);
            ListTag list = nbt.m_128437_(LIST, 10);
            list.forEach(x -> canvas.add(ARRenderAction.deserialize((CompoundTag)x)));
        }
        catch (IOException e) {
            AdvancedPeripherals.LOGGER.error("Failed to decode UpdateHudCanvasMessage: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return new UpdateHudCanvasMessage(canvas);
    }

    public static void encode(UpdateHudCanvasMessage mes, FriendlyByteBuf buf) {
        ByteBufOutputStream stream = new ByteBufOutputStream((ByteBuf)buf);
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        mes.getCanvas().forEach(x -> list.add((Object)x.serializeNBT()));
        nbt.m_128365_(LIST, (Tag)list);
        try {
            NbtIo.m_128941_((CompoundTag)nbt, (DataOutput)stream);
        }
        catch (IOException e) {
            AdvancedPeripherals.LOGGER.error("Failed to encode UpdateHudCanvasMessage: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void handle(UpdateHudCanvasMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> HudOverlayHandler.updateCanvas(mes.getCanvas()));
        cont.get().setPacketHandled(true);
    }

    public List<ARRenderAction> getCanvas() {
        return this.canvas;
    }
}

